<?php

########################################################
#                                                      #
#   Inactive User Manager  v2.3                        #
#    2014 by Outi77 & LordOfDeath                     #
#     Code Anpassung & Optimierung: Mairu              #
#   ------------------------------------------------   #
#   Support: www.ilch.de                               #
#   ------------------------------------------------   #
#   Homepage: Outi77       (www.sivos.de)              #
#             LordOfDeath  (www.altehasen-gaming.de)   #
#             Mairu        (www.mairu.ilch.de)         #
#                                                      #
########################################################

defined ('main') or die ( 'no direct access' );

function inactiveuser () {

    // Modul Konfiguration aus der DB auslesen
    $conf_abf = db_query("SELECT * FROM prefix_user_warn_conf");
    $conf = db_fetch_assoc($conf_abf);

    // Modul aktiviert ?
    if ($conf['warn_active'] == 1) {
        
        require_once 'include/includes/func/inactiveuserfunc.php';
    
        //wenn lastrun kleiner als jetzt-24Stunden...script run
        if ($conf['lastrun'] < strtotime("-1 days", time())) {
            inactiveuser_update_lastrun(time());

            // Aktuelles Datum
            $now = strtotime(date("Y-m-d"));

            // User aus DB lschen, die sich in der Zwischenzeit eingeloggt haben
            $user_back = 3600*24*$conf['time_to_warn1'];
            $del = db_query("SELECT id FROM prefix_user WHERE (llogin + ".$user_back." ) > ".$now);
            while ($row_del = db_fetch_assoc($del)) {
                inactiveuser_del_from_userwarns($row_del['id']);
            }
            
            // User aus Warnliste lschen, die mittlerweile in einem immunen Team sind
            inactiveuser_del_immun_teamusers_from_warnlist();

            // Abgelaufene Aways aus der DB lschen
            if ($conf['away_del'] == 1) {
                $del_oldaway = db_query("SELECT id FROM prefix_awaycal WHERE bis < NOW()");
                while ($del_away = db_fetch_assoc($del_oldaway)) {
                    inactiveuser_del_from_awaycal($del_away['id']);
                }
            }

            // User warn check - Zeitpunkt von jetzt an zurck
            $check_time = strtotime("-".$conf['time_to_warn1']." days", time());

            // Wenn inaktive User nicht warnen aktiviert, diese ausschliessen
            //$andWhere = array('id != 1', 'llogin <= ' . $check_time);
            $andWhere = array('llogin <= ' . $check_time);

            if ( $conf['nowarn_inactive'] == 1 ) {
                $andWhere[] = 'status = 1';
            }

            // Abfrage User Aways
            $andWhere[] = 'id NOT IN (SELECT ac.uid FROM prefix_awaycal ac WHERE ac.von<= DATE(NOW()) AND ac.bis >= DATE(NOW()) AND ac.pruef = 3)';
            
            // User Immun ausschliessen
            $andWhere[] = 'id NOT IN (SELECT im.immunid FROM prefix_user_warn_immun im WHERE im.typ = \'user\')';
            
            // Grundrechte ausschliessen
            $andWhere[] = 'recht NOT IN (SELECT ir.immunid FROM prefix_user_warn_immun ir WHERE ir.typ = \'grundrecht\')';
            
            // Teams ausschlieen - hier werden entsprechende user leider nicht ausgeschlossen, obwohl deren team immun ist
            $andWhere[] = 'id NOT IN (SELECT gu.uid FROM prefix_groupusers gu WHERE gu.gid IN (SELECT it.immunid FROM prefix_user_warn_immun it WHERE it.immunid > 0 AND it.typ = \'team\'))';

            // Abfrage User
            $abf = db_query('SELECT id,name,recht,email,llogin as last_login FROM prefix_user WHERE ' . implode(' AND ', $andWhere));
            while ($row = db_fetch_assoc($abf)) {
                $abf_warn = db_query("SELECT * FROM prefix_user_warn WHERE uid = ".$row['id']);
                if (db_num_rows($abf_warn) == 0) {

                    // Noch kein Eintrag - neu hinzufgen, vorher Differenz zwischen jetzt und letztem Login -> entsprechende Warnung
                    $diff = $now-$row['last_login'];
                    $diff = ceil($diff/86400);
                    if ($diff >= $conf['time_to_warn1']) {
                        $warn_count = 1;
                        $warn_time = $now;
                        $mail_bet  = $conf['mail_titel1'];
                        $mail_text = $conf['mail_txt1'];
                    }
                    db_query("INSERT INTO prefix_user_warn (uid,warn_count,warn_time) VALUES (".$row['id'].",".$warn_count.",".$warn_time.")");

                    list($mailtitle, $mailtext) = inactiveuser_getMailTemplates(1, $row, $conf, $diff);
                    $html = false;
                    icmail($row['email'], $mailtitle, $mailtext, '',$html);

                } else {

                    // User bereits in DB vorhanden - Abfrage wie oft verwarnt
                    while ($r = db_fetch_assoc($abf_warn)) {
                        $diff = $now-$row['last_login'];
                        $diff = ceil($diff/86400);                                
                        $diff2 = $now-$r['warn_time'];
                        $diff2 = ceil($diff2/86400);

                        // Zweite Warnung    
                        if ($r['warn_count'] == 1 AND $diff2 >= $conf['time_to_warn2']) {
                            $new_time_warn = strtotime("+".$conf['time_to_warn2']." days", $r['warn_time']); 
                            $new_warn_count = '2';
                            $mail_bet  = $conf['mail_titel2'];
                            $mail_text = $conf['mail_txt2'];

                            inactiveuser_update_user_warn($row['id'], $new_warn_count, $new_time_warn);

                            // Platzhalter in Mail ersetzen und senden
                            list($mailtitle, $mailtext) = inactiveuser_getMailTemplates(2, $row, $conf, $diff);
                            $html = false;
                            icmail($row['email'], $mailtitle, $mailtext, '',$html); 

                        // Letze Warnung und Aktion    
                        } elseif ($r['warn_count'] == 2 AND $diff2 >= $conf['time_to_warn3']) {
                            $new_time_warn = strtotime("+".$conf['time_to_warn3']." days", $r['warn_time']);
                            $new_warn_count = '3';
                            $mail_bet  = $conf['mail_titel3'];
                            $mail_text = $conf['mail_txt3'];

                            inactiveuser_update_user_warn($row['id'], $new_warn_count, $new_time_warn);

                            // Platzhalter in Mail ersetzen und senden
                            list($mailtitle, $mailtext) = inactiveuser_getMailTemplates(3, $row, $conf, $diff);
                            $html = false;
                            icmail($row['email'], $mailtitle, $mailtext, '',$html);

                            // Automatische Aktionen -> lschen, inaktiv setzen oder nur per Mail benachrichtigen 
                            $name = get_n($row['id']);
                            switch ($conf['warn_del']) {
                                case 0: // => inaktiv setzen
                                    if (!empty($name)) {
                                        inactiveuser_update_userstatus($row['id'], 0);
                                        // => Rechte entziehen
                                        if ($conf['warn_recht'] == 1) {
                                            inactiveuser_degrade_user($row['id']);
                                        }
                                        // PM Texte ermitteln
                                        if ($conf['warn_recht'] == 1 AND $row['recht'] <= -3) {
                                            $pm_text = $name.' hat gerade seine letze inaktiv Warnung erhalten...

                                                Er wurde zu User degradiert.
                                                Eventuell vorhandene Modulrechte und Team Mitgliedschaften wurden gelscht.

                                                >> [url=http://'.$_SERVER['SERVER_NAME'].dirname($_SERVER['PHP_SELF']).'admin.php?userwarns] zur Inaktiv Verwaltung[/url] <<';
                                        } else {
                                            $pm_text = $name.' hat gerade seine letze inaktiv Warnung erhalten...

                                                Sein Account wurde inaktiv gesetzt...

                                                >> [url=http://'.$_SERVER['SERVER_NAME'].dirname($_SERVER['PHP_SELF']).'admin.php?userwarns] zur Inaktiv Verwaltung[/url] <<';
                                        }                     
                                    }            
                                break;
                                case 1: // => Account lschen
                                    if (!empty($name)) {
                                        user_remove($row['id']);
                                        inactiveuser_del_from_userwarns($row['id']);
                                        $pm_text = 'Der Account von '.$name.' wurde aufgrund von inaktivitt gelscht...';
                                    }
                                break;
                                case 2: // => Mail-Benachrichtigung
                                    $pm_text = $name.' hat gerade seine letze inaktiv Warnung erhalten...

                                                >> [url=http://'.$_SERVER['SERVER_NAME'].dirname($_SERVER['PHP_SELF']).'admin.php?userwarns] zur Inaktiv Verwaltung[/url] <<';
                                break;    
                            }
                            // PM senden an alle mit Modulrecht
                            $modul_abf = db_query("SELECT id FROM prefix_modules WHERE url = 'userwarns'");
                            $modul_id = db_result($modul_abf); 
                            $modul_user = db_query("SELECT uid FROM prefix_modulerights WHERE mid = ".$modul_id."");
                            while ($pm_user = db_fetch_assoc($modul_user)) {
                                sendpm(0, $pm_user['uid'], 'Inaktiv Script Info: '.$name.'', ''.$pm_text.'');
                            }                        
                        } 
                    }
                }
            }
        }
    }
}
?>